/****** Object:  StoredProcedure [dbo].[P_SNGPC_ANALISE_PENDENCIA_VENDA]    Script Date: 05/17/2013 14:49:24 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_SNGPC_ANALISE_PENDENCIA_VENDA]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_SNGPC_ANALISE_PENDENCIA_VENDA]
GO

/****** Object:  StoredProcedure [dbo].[P_SNGPC_ANALISE_PENDENCIA_VENDA]    Script Date: 05/17/2013 14:49:24 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE PROCEDURE [dbo].[P_SNGPC_ANALISE_PENDENCIA_VENDA] (@CD_EMP INT, @CD_FILIAL INT)
AS
BEGIN
	/*
	********************************************************************************
	********************************************************************************

									S   A   I   D   A   S
			
			--ENVIAR SAIDAS NO REGISTRADAS E NO PENDENTES, PARA A PENDNCIA--

	********************************************************************************
	********************************************************************************
	*/

	/* LIMPAR AS TABELAS TEMPORARIAS DE USO, CASO NECESSARIO */
	BEGIN TRY
			DROP TABLE #TEMP_DIVERGENCIAS_VENDA;
	END TRY
	BEGIN CATCH
	END CATCH

	SELECT
		I.CD_EMP
		, I.CD_FILIAL
		, I.CD_VD
		, I.CD_IT
		, C.NR_ECF
		, I.CD_PROD
		, S.DS_DCB
		, I.DT_VD
		, P.FLAG_PRODUTO_CONTROLADO CONTROLADO
		, P.ANTIBIOTICO
	INTO #TEMP_DIVERGENCIAS_VENDA	
	FROM PDV_VD_IT I
	INNER JOIN PDV_VD C ON 
			C.CD_EMP = I.CD_EMP 
		AND C.CD_FILIAL = I.CD_FILIAL 
		AND C.CD_VD = I.CD_VD
	INNER JOIN EST_PROD_EST_SNGPC S ON 
			I.CD_EMP = S.CD_EMP 
		AND I.CD_PROD = S.CD_PROD 
	INNER JOIN EST_PROD P ON 
			I.CD_EMP = P.CD_EMP
		AND I.CD_PROD = P.CD_PROD
	WHERE 
			CONVERT(CHAR(10), I.DT_VD, 112) >= (
						SELECT
							TOP 1 CONVERT(CHAR(10), RI.DT_REINICIO, 112)
						FROM EST_SNGPC_REINICIO_INVENTARIO RI
						WHERE
								RI.CD_EMP = I.CD_EMP
							AND RI.CD_FILIAL = I.CD_FILIAL
						ORDER BY
								CD_REINICIO DESC
						)
		AND I.CD_EMP = @cd_emp
		AND ((I.CD_FILIAL = @cd_filial) OR (@cd_filial = 0))
		AND NOT EXISTS (
			SELECT CD_EMP 
			FROM PDV_VD_IT_EST_SNGPC_PENDENTE T 
			WHERE 
					T.CD_EMP = I.CD_EMP 
				AND T.CD_FILIAL = I.CD_FILIAL 
				AND T.CD_IT = I.CD_IT 
				AND T.CD_VD = I.CD_VD
			)
		AND NOT EXISTS (
			SELECT CD_EMP 
			FROM PDV_VD_IT_EST_SNGPC_SAIDA T 
			WHERE 
					T.CD_EMP = I.CD_EMP 
				AND T.CD_FILIAL = I.CD_FILIAL 
				AND T.CD_VD = I.CD_VD
				AND T.CD_IT = I.CD_IT 
			)
	ORDER BY I.CD_PROD;

	--SELECT * FROM #TEMP_DIVERGENCIAS_VENDA;

	INSERT INTO PDV_VD_IT_EST_SNGPC_PENDENTE
	SELECT CD_EMP, CD_FILIAL, CD_VD, CD_IT, GETDATE() FROM #TEMP_DIVERGENCIAS_VENDA;

	BEGIN TRY
			DROP TABLE #TEMP_DIVERGENCIAS_VENDA;
	END TRY
	BEGIN CATCH
	END CATCH

END
GO


